<?php
// reset_password.php (PROTEGIDO por login del panel userAdd.php)
// - Requiere sesión de panel: $_SESSION['panel_user_id'] y rol admin/superadmin
// - Mantiene la lógica funcional de búsqueda/actualización por teléfono

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

require_once __DIR__ . '/../includes/db.php';

// ==========================
// 1) Protección por sesión del panel (userAdd.php)
// ==========================
$panelUserId   = $_SESSION['panel_user_id']   ?? null;
$panelUserName = $_SESSION['panel_user_name'] ?? '';
$panelUserRole = $_SESSION['panel_user_role'] ?? '';

$rolesPanel = ['admin', 'superadmin'];

if (!$panelUserId || !in_array((string)$panelUserRole, $rolesPanel, true)) {
    // No está logueado al panel: enviar a userAdd.php (login del panel)
    header('Location: userAdd.php');
    exit;
}

header('Content-Type: text/html; charset=utf-8');

// ==========================
// 2) Lógica original
// ==========================

// NO usamos current_user() ni auth.php para que dependa SOLO del login del panel
$pdo = pdo();

$msg    = '';
$msg_ok = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phoneRaw = trim($_POST['phone'] ?? '');
    $pass1    = (string)($_POST['password'] ?? '');
    $pass2    = (string)($_POST['password_confirm'] ?? '');

    $msg = '';
    $msg_ok = '';

    // Normaliza: solo dígitos
    $digits = preg_replace('/\D+/', '', $phoneRaw);

    if ($phoneRaw === '' || $pass1 === '' || $pass2 === '') {
        $msg = 'Completa todos los campos.';
    } elseif ($pass1 !== $pass2) {
        $msg = 'Las contraseñas no coinciden.';
    } elseif (strlen($pass1) < 4) {
        $msg = 'La contraseña debe tener al menos 4 caracteres.';
    } elseif ($digits === '' || strlen($digits) < 7) {
        // mínimo razonable para evitar búsquedas demasiado abiertas
        $msg = 'Captura un teléfono válido (de preferencia 10 dígitos).';
    } else {
        try {
            // Usaremos los últimos 10 dígitos para matchear contra +521XXXXXXXXXX o +1XXXXXXXXXX
            $last10 = (strlen($digits) >= 10) ? substr($digits, -10) : $digits;

            // 1) Si existe la columna phone_national_10, es la forma más exacta
            $hasNat10 = false;
            try {
                $chk = $pdo->prepare("
                    SELECT COUNT(*)
                    FROM information_schema.columns
                    WHERE table_schema = DATABASE()
                      AND table_name = 'users'
                      AND column_name = 'phone_national_10'
                ");
                $chk->execute();
                $hasNat10 = ((int)$chk->fetchColumn() > 0);
            } catch (Throwable $e) {
                $hasNat10 = false; // si falla, usamos fallback
            }

            if ($hasNat10) {
                // Buscar por national_10 (ideal)
                $stmt = $pdo->prepare("
                    SELECT id
                    FROM users
                    WHERE phone_national_10 = ?
                    LIMIT 2
                ");
                $stmt->execute([$last10]);
            } else {
                // Fallback: buscar por terminación de 10 dígitos en phone (+521... o +1...)
                // También intenta match exacto por si alguien pega el E164 completo.
                $like = '%' . $last10;
                $stmt = $pdo->prepare("
                    SELECT id
                    FROM users
                    WHERE phone = ?
                       OR phone LIKE ?
                    LIMIT 2
                ");
                $stmt->execute([$phoneRaw, $like]);
            }

            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (!$rows) {
                $msg = 'No se encontró un usuario con ese teléfono.';
            } elseif (count($rows) > 1) {
                // Muy raro, pero posible si hay duplicados por país u otras razones
                $msg = 'Se encontró más de un usuario con ese número. Captura el teléfono completo (con lada) para evitar ambigüedad.';
            } else {
                $userId = (int)$rows[0]['id'];

                // Actualiza password_hash
                $hash = password_hash($pass1, PASSWORD_DEFAULT);

                $upd = $pdo->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
                $upd->execute([$hash, $userId]);

                $msg_ok = 'Contraseña actualizada correctamente. Ya puedes iniciar sesión en la app.';
            }
        } catch (Exception $e) {
            $msg = 'Error al actualizar la contraseña: ' . $e->getMessage();
        }
    }
}

// pequeña función de escape por si no tienes h() aquí
function e($s){
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Restablecer contraseña · Ventas Blanquita</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card shadow-sm border-0">
        <div class="card-body">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h1 class="h5 mb-0 text-primary">Restablecer contraseña</h1>
            <span class="badge bg-primary-subtle text-primary border border-primary-subtle">
              <?= e($panelUserRole) ?>
            </span>
          </div>

          <p class="text-muted small mb-4">
            Acceso protegido por el login del panel. Conectado como: <strong><?= e($panelUserName) ?></strong>
          </p>

          <?php if ($msg): ?>
            <div class="alert alert-danger py-2"><?= e($msg) ?></div>
          <?php endif; ?>

          <?php if ($msg_ok): ?>
            <div class="alert alert-success py-2"><?= e($msg_ok) ?></div>
          <?php endif; ?>

          <form method="post" autocomplete="off">
            <div class="mb-3">
              <label class="form-label">Teléfono registrado</label>
              <input type="text" name="phone" class="form-control" required placeholder="10 dígitos o +521...">
              <div class="form-text">Se buscará por coincidencia exacta o por los últimos 10 dígitos.</div>
            </div>

            <div class="mb-3">
              <label class="form-label">Nueva contraseña</label>
              <input type="password" name="password" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Confirmar contraseña</label>
              <input type="password" name="password_confirm" class="form-control" required>
            </div>

            <button class="btn btn-primary w-100">Actualizar contraseña</button>
          </form>

          <hr class="my-3">

          <div class="d-flex justify-content-between">
            <a href="userAdd.php" class="small">Volver al panel</a>
            <a href="userAdd.php?logout_panel=1" class="small text-danger">Salir del panel</a>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>

</body>
</html>
