<?php
// sms_worker.php
// Procesa la cola sms_outbox. Útil para cron (recomendado) o para diagnóstico manual.
//
// Uso sugerido (cron cada 1-5 min):
//   php -d detect_unicode=0 /path/to/ventasApp/sms_worker.php key=MI_LLAVE
// o vía web:
//   https://tudominio.com/ventasApp/sms_worker.php?key=MI_LLAVE
//
// La llave se toma de (en orden):
// - includes/config.local.php: ['sms']['worker_key']
// - Variable de entorno: VB_SMS_WORKER_KEY
//
// Responde JSON.

declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/sms_outbox.php';

function cfg_worker_key(): string {
    $cfg = function_exists('app_config') ? (app_config() ?: []) : [];
    $k = '';
    if (is_array($cfg['sms'] ?? null)) $k = (string)($cfg['sms']['worker_key'] ?? '');
    if ($k === '') $k = (string)(getenv('VB_SMS_WORKER_KEY') ?: '');
    return trim($k);
}

// key por GET o por argv (para cron CLI)
$key = (string)($_GET['key'] ?? '');
if ($key === '' && PHP_SAPI === 'cli' && isset($argv) && is_array($argv)) {
    foreach ($argv as $a) {
        if (str_starts_with($a, 'key=')) $key = substr($a, 4);
    }
}

$expected = cfg_worker_key();
if ($expected !== '') {
    if ($key === '' || !hash_equals($expected, $key)) {
        http_response_code(401);
        echo json_encode(['ok' => false, 'error' => 'UNAUTHORIZED'], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

try {
    $pdo = pdo();
    $res = sms_process_outbox($pdo, 50, 5);
    echo json_encode(['ok' => true, 'result' => $res], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'EXCEPTION', 'detail' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
