<?php
/**
 * tools/generate_worker_key.php
 * Genera una llave segura para wa_worker_key.
 * Úsalo una sola vez, copia la llave y borra este archivo del servidor.
 */

header('Content-Type: text/plain; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

function base64url_encode(string $bin): string {
  return rtrim(strtr(base64_encode($bin), '+/', '-_'), '=');
}

// Tamaño recomendado: 32 bytes (256 bits)
$bytes = 32;

try {
  $raw = random_bytes($bytes);
  // Formato amigable: base64url (sin + / =)
  $key = base64url_encode($raw);

  echo "wa_worker_key:\n";
  echo $key . "\n\n";
  echo "Longitud: " . strlen($key) . " caracteres\n";
  echo "Sugerencia: pega esta llave en includes/config.local.php y luego elimina este archivo.\n";

} catch (Throwable $e) {
  http_response_code(500);
  echo "Error generando llave: " . $e->getMessage() . "\n";
}
